---
obsidianUIMode: preview
---

This section sets out a simple calculation you can keep in your head to give you a gauge of the difficulty of an encounter. This "lazy encounter benchmark" isn't perfect or precise. Rather, it's a tool for getting a rough sense of the potential challenge of a combat encounter–and for recognizing when an encounter crosses over from challenging to potentially deadly. Think of it like a tachometer measuring how fast the engine is running in a car. If you go beyond the limit defined by the benchmark, you're "in the red"–pushing to a point where your encounter might be more than the characters can handle.

## Using the Benchmark

The primary calculation of the lazy encounter benchmark compares the challenge ratings of monsters with the levels of the characters in the following way:

**An encounter might be deadly if the sum total of monster challenge ratings is greater than 1/4 of the sum total of character levels, for characters of 1st to 4th level; or greater than 1/2 of the sum total of character levels, for characters of 5th level or higher.**

What exactly does "deadly" mean in this context? In a deadly encounter:

* Most characters might lose more than half their hit points.
* Several characters might go unconscious.
* There's a chance that one or more characters might die.

For example, imagine an encounter pitting five 4th-level characters against four ogres of CR 2. To see how dangerous this fight might be, add all the character levels together and divide by 4 (because they're lower than 5th level), giving a result of 20 ÷ 4 = 5. Now compare that result to the sum of monster challenge ratings, with four CR 2 ogres giving a total of 8. Because 8 is more than 5, this could be a potentially deadly encounter.

Above 4th level, you divide character levels by 2 instead of 4 because of the extra resources and synergies characters gain at 5th level and higher. Going back to the previous example, if the characters were 5th level instead of 4th, their total levels would be 25. The benchmark gives a result of 25 ÷ 2 = 12 (rounded down, as usual in the game). The four ogres still have a total CR of 8, and with 8 less than 12, these fifth-level characters aren't likely to find this a deadly fight.

As another example, consider six 8th-level characters facing three CR 11 horned devils. Dividing the total character levels of 48 by 2 gives a result of 24. Adding up the challenge ratings of the horned devils gives you 33. So with 33 much higher than 24, that's a potentially deadly fight.

Still, even when a calculated benchmark suggests that an encounter might be too tough, that doesn't mean you should automatically change things up. The lazy encounter benchmark is there to give you a warning sign that your encounter might be into the danger zone where it becomes more than the characters can handle. But your own experiences with the characters and players should ultimately tell you whether you should change things up or not.

The lazy encounter benchmark intentionally doesn't provide specific measurements for easy, medium, or hard encounters. Instead, think of it like an analog gauge. The lower the total monster challenge ratings are compared to the benchmark calculation from character levels, the easier the battle might be. The higher the total monster challenge ratings are above the benchmark, the deadlier the battle might be.

> ***Write Down the Benchmark Result***

> Because the benchmark result only changes when the characters increase in level, you can write it down and keep it in your notes. If you're going to have five 8th-level characters in your next several sessions, you can write down "Lazy Encounter Benchmark: 20" and reference that when throwing monsters together for an encounter. It's especially useful to keep this number in front of you when improvising encounters during a session.

## Optional Scaling for Higher Levels

As characters rise in level above 10th, their increased power and synergies mean that you might find the benchmark becomes less accurate about representing the potential deadliness of encounters. If this is the case in your games, you can scale up the benchmark equation for higher-level characters with the following variation:

**An encounter might be deadly if the sum total of monster challenge ratings is greater than 3/4 of the sum total of character levels, for characters of 11th to 16th level; or equal to the sum total of character levels, for characters of 17th level or higher.**

Explore this option only if it feels as though encounters assessed using the original benchmark are consistently underpowered for your group. But if you need it, this option sets the benchmark for truly dangerous encounters at the highest levels, where characters of great heroic capability might face several powerful creatures in a single battle.

## The CR Cap for a Single Monster

Although the lazy encounter benchmark uses the total challenge ratings of all monsters in an encounter, it doesn't take into consideration the maximum challenge rating for any single monster, either alone or with a group. For that, you can use a different benchmark calculation to describe when a single monster of a particular challenge rating might represent a deadly challenge for characters of a given level, whether battled alone or in a group:

**A single monster might be deadly if their challenge rating is equal to or higher than the average level of the characters, or 1.5 times the average level of the characters if the characters are 5th level or higher.**

## Tuning the Benchmark

Given the many different circumstances that can affect character power and encounter difficulty, you might want to tune the benchmark calculation up or down to serve as a more accurate guideline for your own group. To do so, simply increase or decrease the number of characters you use to calculate the sum total of character levels, treating that as a dial for tuning the benchmark for your own group.

For example, if a party in your campaign has companion NPCs who make combat easier, or if characters employ spells that often remove monsters from combat, you can pretend the group consists of six characters instead of their actual five and calculate the benchmark that way. Likewise, if a group regularly gets into trouble in encounters where the sum total of monster CR is well below the benchmark, pretend the party has four characters instead of five.

## Other Considerations

Many circumstances can change how challenging an actual combat encounter might be. All of the following examples set up types of encounters that often play out more easily than the lazy encounter benchmark might suggest:

* The fight features significantly more characters than foes.
* The characters' goals in an encounter can be achieved without eliminating all the foes from the fight.
* The environment favors the characters.
* The monsters come in waves instead of all at once.
* Foes are distracted or in disadvantageous positions.
* The monsters are all surprised, or all act after the characters in initiative.
* The characters have spells or features well suited for taking out foes.
* The players engage in excellent tactical behavior and synergistic strategies.
* The characters are well rested and coming in fresh.
* The characters have an arsenal of powerful magic items.
* The characters have useful companions.

Likewise, the monsters might be favored over the characters in the following types of encounters:

* The monsters outnumber the characters.
* The characters are surprised by the monsters.
* Foes have advantageous position.
* The terrain favors the foes.
* The monsters fight with a strong tactical synergy.
* The characters are coming in well worn by previous fights and have no chance to rest.

As you make use of the benchmark, you'll soon come to recognize when the circumstances of a combat encounter might steer it toward an easier or harder fight.

> ***Alternative Benchmark***

> An alternative approach to the lazy encounter benchmark lets you compare monster challenge ratings and character levels with a single straightforward formula, as follows:

> To assess the strength of the characters relative to the monsters they face, take the sum total of all character levels and divide by 4. Then multiply that number by the characters' tier.

> At 1st tier (levels 1 to 4), the benchmark is simply the total of all character levels divided by 4. But as characters rise in level and across the tiers of play, they experience three distinct bumps in power at 5th level (the start of the second tier, multiplying the benchmark by 2), 11th level (the start of the third tier, for a ×3 multiplier), and 17th level (the start of the fourth tier, for a ×4 multiplier).

> In a broad sense, characters of the second tier can be thought of as effectively twice as powerful as characters of the first tier, with characters of the third and fourth tiers increasing in power yet again. However, as with the default versions of the benchmarks, it's important to remember that increasing the multipliers for the third and fourth tier is optional, and should be done only if you find that encounters created with the ×2 multiplier aren't keeping up to the characters.
